package edu.uky.ai.lp.logic;

/**
 * Represents an expression with 1 or more disjuncts, at least one of which
 * must be true.
 * 
 * @author Stephen G. Ware
 */
public class Disjunction extends NAryBooleanExpression {
	
	/**
	 * Constructs a new disjunction with the given arguments.
	 * 
	 * @param disjuncts the disjuncts
	 */
	public Disjunction(Expression...disjuncts) {
		super("or", disjuncts);
	}
	
	@Override
	public String toString() {
		return toString("; ");
	}
	
	@Override
	public Disjunction substitute(Unifier unifier) {
		return new Disjunction(substituteArguments(unifier));
	}
}
